# 画面設計書 157-Cat リカバリ

## 概要

本ドキュメントは、OpenSearchのCat Recovery API（`GET /_cat/recovery`）エンドポイントに関する画面設計書である。シャードリカバリの進行状況をテーブル形式で返すAPIの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：シャードリカバリの状態を一覧形式で確認するために使用される。クラスタの再起動後のリカバリ進捗、スナップショットからのリストア状況、レプリカシャードの割り当て進捗などを監視するために重要なAPIである。リカバリのタイプ（store/snapshot/peer/empty_store）、ステージ、ファイル・バイト・トランスログの進捗率を表示する。

**画面へのアクセス方法**：HTTPクライアントから `GET /_cat/recovery` または `GET /_cat/recovery/{index}` にリクエストを送信してアクセスする。

**主要な操作・処理内容**：
1. RecoveryRequestをインデックス管理APIに発行する
2. RecoveryResponseからシャードごとのリカバリ状態を取得する
3. シャードIDでソートし、各リカバリ状態をテーブル行として構築する

**画面遷移**：本APIはステートレスなREST APIである。インデックスリカバリAPI（`GET /{index}/_recovery`）と関連する。

**権限による表示制御**：セキュリティプラグインが有効な場合、インデックスモニタリング権限が必要となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 107 | シャードリカバリ | 主機能 | シャードリカバリの進行状況をテーブル形式で返す処理 |

## 画面種別

一覧（テーブル形式のリカバリ状態表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat/recovery` | 全インデックスのリカバリ情報をテーブル形式で返す |
| GET | `/_cat/recovery/{index}` | 指定インデックスのリカバリ情報をテーブル形式で返す |

## 入出力項目

### リクエストパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| index | list | No | - | インデックス名のカンマ区切りリスト（パスパラメータ） |
| format | string | No | - | レスポンス形式（json, yamlなど） |
| active_only | boolean | No | false | アクティブなリカバリのみ表示 |
| bytes | enum | No | - | バイト値の表示単位 |
| detailed | boolean | No | false | 詳細情報を含む |
| h | list | No | - | 表示するカラム名のカンマ区切りリスト |
| help | boolean | No | false | ヘルプ情報を返す |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |
| time | enum | No | - | 時間値の表示単位 |
| v | boolean | No | false | 冗長モード。カラムヘッダーを表示 |

## 表示項目

| カラム名 | エイリアス | デフォルト表示 | 説明 |
|---------|-----------|-------------|------|
| index | i,idx | Yes | インデックス名 |
| shard | s,sh | Yes | シャード番号 |
| start_time | start | No | リカバリ開始時刻 |
| start_time_millis | start_millis | No | リカバリ開始時刻（エポックミリ秒） |
| stop_time | stop | No | リカバリ停止時刻 |
| stop_time_millis | stop_millis | No | リカバリ停止時刻（エポックミリ秒） |
| time | t,ti | Yes | リカバリ時間 |
| type | ty | Yes | リカバリタイプ（store/snapshot/peer/empty_store等） |
| stage | st | Yes | リカバリステージ |
| source_host | shost | Yes | ソースホスト名 |
| source_node | snode | Yes | ソースノード名 |
| target_host | thost | Yes | ターゲットホスト名 |
| target_node | tnode | Yes | ターゲットノード名 |
| repository | rep | Yes | リポジトリ名（スナップショットリカバリのみ） |
| snapshot | snap | Yes | スナップショット名（スナップショットリカバリのみ） |
| files | f | Yes | リカバリ対象ファイル数 |
| files_recovered | fr | Yes | リカバリ済みファイル数 |
| files_percent | fp | Yes | ファイルリカバリ進捗率 |
| files_total | tf | Yes | 総ファイル数 |
| bytes | b | Yes | リカバリ対象バイト数 |
| bytes_recovered | br | Yes | リカバリ済みバイト数 |
| bytes_percent | bp | Yes | バイトリカバリ進捗率 |
| bytes_total | tb | Yes | 総バイト数 |
| translog_ops | to | Yes | トランスログ操作数 |
| translog_ops_recovered | tor | Yes | リカバリ済みトランスログ操作数 |
| translog_ops_percent | top | Yes | トランスログリカバリ進捗率 |

## イベント仕様

### 1-GETリクエスト受信

クライアントからのGETリクエストを受信すると、`RestCatRecoveryAction.doCatRequest()` が呼び出される。RecoveryRequestを生成し、インデックスリカバリ情報を取得する。レスポンスからシャードIDでソートされたリカバリ状態のテーブルを構築する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GETリクエスト | - | SELECT | 参照のみ。データベースへの更新は発生しない |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|-------------|
| 正常応答 | リカバリ情報取得成功時 | テーブル形式のリカバリ情報 |
| 正常応答 | リカバリが0件の場合 | 空のレスポンス |

## 例外処理

- インデックスが存在しない場合：IndexNotFoundExceptionが返される
- ソースノードがnullの場合：source_hostとsource_nodeに"n/a"が表示される（行182-183）

## 備考

- シャードリカバリ状態はシャードIDの昇順でソートされる（CollectionUtil.introSort）
- スナップショットリカバリでない場合、repositoryとsnapshotは"n/a"が表示される
- active_only=trueで進行中のリカバリのみフィルタ可能
- 進捗率は"X.X%"形式で表示される（例："95.2%"）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RecoveryState.java | `server/src/main/java/org/opensearch/indices/recovery/RecoveryState.java` | getShardId(), getTimer(), getStage(), getRecoverySource(), getIndex(), getTranslog()を保持 |
| 1-2 | RecoverySource.java | `server/src/main/java/org/opensearch/cluster/routing/RecoverySource.java` | リカバリタイプ（STORE, SNAPSHOT, PEER, EMPTY_STORE等）の定義 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestCatRecoveryAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestCatRecoveryAction.java` | Cat Recovery APIのエントリーポイント |

**主要処理フロー**:
1. **行71-72**: `routes()` で2つのルート登録
2. **行87-99**: `doCatRequest()` でRecoveryRequestを生成・発行
3. **行103-134**: `getTableWithHeader()` で26カラムのテーブルヘッダー定義
4. **行144-212**: `buildRecoveryTable()` でインデックス・シャードごとにソートしてテーブル構築

### プログラム呼び出し階層図

```
RestCatRecoveryAction.doCatRequest() [行87]
    |
    +-- RecoveryRequest(indices) [行88]
    |
    +-- client.admin().indices().recoveries() [行94]
           |
           +-- buildRecoveryTable() [行144]
                  +-- getTableWithHeader() [行103]
                  +-- CollectionUtil.introSort() [行156]
                  +-- RecoveryState -> テーブル行変換 [行171-208]
```

### データフロー図

```
[入力]                     [処理]                          [出力]

GET /_cat/recovery     --> RestCatRecoveryAction          --> テーブル形式
GET /_cat/recovery/{i}      |
                            v
                       RecoveryRequest
                            |
                            v
                       RecoveryResponse
                            |
                            v
                       shardRecoveryStates (インデックスごと)
                            |
                            v
                       introSort (シャードIDでソート)
                            |
                            v
                       buildRecoveryTable() --> RestTable.buildResponse()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestCatRecoveryAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestCatRecoveryAction.java` | ソース | Cat Recovery APIのRESTハンドラ |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API共通基底クラス |
| RecoveryState.java | `server/src/main/java/org/opensearch/indices/recovery/RecoveryState.java` | ソース | リカバリ状態データ構造 |
| RecoverySource.java | `server/src/main/java/org/opensearch/cluster/routing/RecoverySource.java` | ソース | リカバリソースタイプ定義 |
| cat.recovery.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.recovery.json` | 設定 | REST API仕様定義 |
